from fastapi import APIRouter, HTTPException, Depends
from pydantic import BaseModel, EmailStr
from models.users import UserModel
from utils.email import send_email
from fastapi import Request
from fastapi.templating import Jinja2Templates

templates = Jinja2Templates(directory="templates")
router = APIRouter()

class UserRegister(BaseModel):
    email: EmailStr
    password: str
    full_name: str

class UserLogin(BaseModel):
    email: EmailStr
    password: str

@router.get("/register")
async def register_page(request: Request):
    return templates.TemplateResponse("auth/register.html", {"request": request})
    
@router.post("/register")
async def register(user_data: UserRegister):
    # Check if user exists
    if UserModel.get_user_by_email(user_data.email):
        raise HTTPException(status_code=400, detail="Email already registered")
    
    # Create user
    user = UserModel.create_user(
        email=user_data.email,
        password=user_data.password,
        full_name=user_data.full_name
    )
    
    # Send verification email
    verification_code = UserModel.create_verification_code(user['id'], "verification")
    html_content = f"""
    <h1>Welcome to Server Sentry!</h1>
    <p>Your verification code is: <strong>{verification_code}</strong></p>
    <p>This code will expire in 5 minutes.</p>
    """
    send_email(
        user_data.email,
        "Verify your Server Sentry account",
        html_content
    )
    
    return {"message": "Registration successful. Please check your email for verification."}