import sys
import os
from fastapi import FastAPI, Request
from fastapi.responses import HTMLResponse
from fastapi.templating import Jinja2Templates
from fastapi.staticfiles import StaticFiles
from pathlib import Path

current_dir = os.path.dirname(os.path.abspath(__file__))
dashboard_path = os.path.join(current_dir, 'Dashboard')
sys.path.insert(0, dashboard_path)

app = FastAPI(title="Server Sentry")
templates = Jinja2Templates(directory=os.path.join(dashboard_path, "templates"))

def application(environ, start_response):
    path_info = environ.get('PATH_INFO', '')
    
    request = Request(scope={
        'type': 'http',
        'method': environ.get('REQUEST_METHOD', 'GET'),
        'path': path_info,
        'query_string': environ.get('QUERY_STRING', '').encode('utf-8'),
        'headers': []
    })
    
    try:
        if path_info == '/auth/register':
            response_body = templates.TemplateResponse(
                "auth/register.html",
                {"request": request}
            ).body
        else:
            response_body = templates.TemplateResponse(
                "index.html",
                {"request": request}
            ).body
            
        start_response('200 OK', [('Content-Type', 'text/html')])
        return [response_body]
        
    except Exception as e:
        print(f"Error in application: {e}", file=sys.stderr)
        start_response('500 Internal Server Error', [('Content-Type', 'text/plain')])
        return [str(e).encode()]